//=============================================================================
// Button1.
//=============================================================================
class VendorButton extends DeusExDecoration;

var int ButtonNum;
var MSVendor Vendor;
var sound Button1Sound;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;
var rotator rpcRotation;

var Actor LastFrobber;


var float TimeSinceFrob;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation, rpcRotation;
}

function Frob(Actor Frobber, Inventory frobWith)
{
		PlaySound(button1Sound, SLOT_None);

              if (Frobber == LastFrobber)		
               Vendor.VendorButtonPushed(ButtonNum, DeusExPlayer(Frobber));

              else
              {
               LastFrobber = Frobber;
               Pawn(Frobber).ClientMessage("|p4Press this button again to buy a "$Vendor.DispensedItems[ButtonNum - 1]$" for |p3"$Vendor.ItemCosts[ButtonNum - 1]$" dollars!");
              }

		Super.Frob(Frobber, frobWith);
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 SetBase(Owner);
 if ((Owner != None) && (Owner.IsA('MSVendor')))
  Vendor = MSVendor(Owner);
 else
  log("ERROR "$Self$" Can not find master vendor!");
// SetTimer(0.5, True);
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
			{
				rpcLocation = Location;
                                rpcRotation = Rotation;
			}
			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				SetRotation( rpcRotation );
				lastLoc = rpcLocation;
			}
		}
	}

	if (lastfrobber != None) TimeSinceFrob += deltaTime;

	if (TimeSinceFrob > 30)
	{
		lastfrobber = None;
		TimeSinceFrob = 0;	
	}

	Super.Tick( deltaTime );
}
defaultproperties
{
     button1Sound=Sound'DeusExSounds.Generic.Beep1'
     bBlockActors=True
     bBlockPlayers=True
     bInvincible=True
     ItemName="Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     Mass=5.000000
     Buoyancy=2.000000
}
